/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.impl;

import com.cisco.pt.EncodedBuffer;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.LTVImpl;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPCMessageLTV
extends LTVImpl {
    protected int messageId;
    protected List<IPCCall> calls = new ArrayList<IPCCall>();

    public IPCMessageLTV() {
        this.setType(100);
        this.messageId = LTVImpl.getNextMessageId();
    }

    @Override
    public boolean hasResponse() {
        return true;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public void encodeTypeAndPayload(EncodedBuffer buff) {
        buff.putInt(this.getType());
        buff.putInt(this.messageId);
        for (IPCCall call : this.calls) {
            call.encode(buff);
        }
    }

    public List<IPCCall> getCalls() {
        return this.calls;
    }

    public void addCalls(IPCMessageLTV otherMessage) {
        this.calls.addAll(otherMessage.getCalls());
    }

    public void addCall(IPCCall call) {
        this.calls.add(call);
    }
}

